/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.StringTextComponent;

public class ListView<T>
extends Widget {
    private final FontRenderer font;
    private final Iterable<T> entries;
    private final List<T> displayList = new ArrayList<T>();
    private Predicate<T> filter;
    private ISelected<T> onSelect;
    private Function<T, String> formatter;
    private int scrollOffset;
    private final int elementDisplayLimit;
    private int selectedIndex;

    public ListView(int x, int y, int width, int height, Iterable<T> entries) {
        this(x, y, width, height, entries, t -> true);
    }

    public ListView(int x, int y, int width, int height, Iterable<T> entries, Predicate<T> filter) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.entries = entries;
        this.formatter = Object::toString;
        this.elementDisplayLimit = height / 15;
        this.setFilter(filter);
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        ListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-1744830464);
        for (int i = this.scrollOffset; i < this.scrollOffset + this.elementDisplayLimit && i < this.displayList.size(); ++i) {
            int renderIndex = i - this.scrollOffset;
            T t = this.displayList.get(i);
            String name = this.formatter.apply(t);
            int y1 = this.field_230691_m_ + renderIndex * 15;
            if (i == this.selectedIndex) {
                ListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)y1, (int)(this.field_230690_l_ + this.field_230688_j_ - 4), (int)(y1 + 15), (int)-1728053249);
            } else if (this.isHovered(renderIndex, mouseX, mouseY)) {
                ListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)y1, (int)(this.field_230690_l_ + this.field_230688_j_ - 4), (int)(y1 + 15), (int)0x67FFFFFF);
            }
            this.font.func_238421_b_(stack, name, (float)(this.field_230690_l_ + 2), (float)(y1 + 3), 0xFFFFFF);
        }
        this.drawScrollbar(stack);
    }

    public void func_230982_a_(double xMouse, double yMouse) {
        int index = (int)(yMouse - (double)this.field_230691_m_) / 15;
        int offsetIndex = this.scrollOffset + index;
        if (index >= 0 && index < this.displayList.size()) {
            this.trySelect(this.displayList.get(offsetIndex), offsetIndex);
        } else {
            this.trySelect(null, -1);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (amount != 0.0 && this.func_231047_b_(mouseX, mouseY)) {
            this.onScroll((int)amount);
            return true;
        }
        return false;
    }

    public void onScroll(int amount) {
        int i = -amount;
        int j = this.scrollOffset + i;
        if (j >= 0 && j <= this.displayList.size() - this.elementDisplayLimit) {
            this.scrollOffset = j;
        }
    }

    public void setFilter(Predicate<T> entryFilter) {
        this.filter = Objects.requireNonNull(entryFilter);
        this.scrollOffset = 0;
        this.updateDisplayList();
    }

    public void setFormatter(Function<T, String> formatter) {
        this.formatter = Objects.requireNonNull(formatter);
    }

    public void setResponder(ISelected<T> responder) {
        this.onSelect = responder;
    }

    private void drawScrollbar(MatrixStack stack) {
        int left = this.field_230690_l_ + this.field_230688_j_ - 2;
        int right = left + 2;
        int top = this.field_230691_m_;
        int bottom = top + this.field_230689_k_;
        double size = 1.0 / (double)this.displayList.size() * (double)this.field_230689_k_;
        int scrollbarY = (int)((double)this.scrollOffset * size);
        int scrollbarHeight = (int)Math.ceil((double)Math.min(this.elementDisplayLimit, this.displayList.size()) * size);
        ListView.func_238467_a_((MatrixStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)-16777216);
        ListView.func_238467_a_((MatrixStack)stack, (int)left, (int)(top + scrollbarY), (int)right, (int)(top + scrollbarY + scrollbarHeight), (int)-1);
    }

    private void trySelect(T t, int index) {
        if (this.onSelect != null) {
            this.onSelect.onSelect(t);
        }
        this.selectedIndex = index;
    }

    private void updateDisplayList() {
        this.displayList.clear();
        for (T t : this.entries) {
            if (!this.filter.test(t)) continue;
            this.displayList.add(t);
        }
        this.selectedIndex = -1;
    }

    private boolean isHovered(int renderIndex, int mouseX, int mouseY) {
        int x1 = this.field_230690_l_;
        int x2 = this.field_230690_l_ + this.field_230688_j_ - 4;
        int y1 = this.field_230691_m_ + renderIndex * 15;
        int y2 = y1 + 15;
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY < y2;
    }

    public static interface ISelected<T> {
        public void onSelect(@Nullable T var1);
    }
}

